/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authtoken;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authtoken.AuthToken;
import com.floragunn.searchguard.authtoken.AuthTokenPrivilegeBase;
import com.floragunn.searchguard.authtoken.AuthTokenServiceConfig;
import com.floragunn.searchguard.authtoken.InvalidTokenException;
import com.floragunn.searchguard.authtoken.NoSuchAuthTokenException;
import com.floragunn.searchguard.authtoken.RequestedPrivileges;
import com.floragunn.searchguard.authtoken.RestrictedActionAuthorization;
import com.floragunn.searchguard.authtoken.TokenCreationException;
import com.floragunn.searchguard.authtoken.TokenUpdateException;
import com.floragunn.searchguard.authtoken.api.CreateAuthTokenRequest;
import com.floragunn.searchguard.authtoken.api.CreateAuthTokenResponse;
import com.floragunn.searchguard.authtoken.update.PushAuthTokenUpdateAction;
import com.floragunn.searchguard.authtoken.update.PushAuthTokenUpdateRequest;
import com.floragunn.searchguard.authtoken.update.PushAuthTokenUpdateResponse;
import com.floragunn.searchguard.authz.ActionAuthorization;
import com.floragunn.searchguard.authz.AuthorizationService;
import com.floragunn.searchguard.authz.PrivilegesEvaluator;
import com.floragunn.searchguard.authz.actions.Actions;
import com.floragunn.searchguard.authz.config.Role;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ProtectedConfigIndexService;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.privileges.SpecialPrivilegesEvaluationContext;
import com.floragunn.searchguard.privileges.SpecialPrivilegesEvaluationContextProvider;
import com.floragunn.searchguard.sgconf.history.ConfigHistoryService;
import com.floragunn.searchguard.sgconf.history.ConfigModel;
import com.floragunn.searchguard.sgconf.history.ConfigSnapshot;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import com.floragunn.searchguard.user.User;
import com.floragunn.searchsupport.StaticSettings;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.indices.IndexCleanupAgent;
import com.floragunn.searchsupport.xcontent.ObjectTreeXContent;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Sets;
import com.google.common.io.BaseEncoding;
import java.nio.ByteBuffer;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.cxf.rs.security.jose.jwa.ContentAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionOutput;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jws.JwsJwtCompactConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rs.security.jose.jwt.JoseJwtProducer;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.jose.jwt.JwtException;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.jose.jwt.JwtUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;

public class AuthTokenService
implements SpecialPrivilegesEvaluationContextProvider {
    private static final Logger log = LogManager.getLogger(AuthTokenService.class);
    public static final StaticSettings.Attribute<String> INDEX_NAME = StaticSettings.Attribute.define((String)"searchguard.authtokens.index.name").withDefault(".searchguard_authtokens").asString();
    public static final StaticSettings.Attribute<TimeValue> CLEANUP_INTERVAL = StaticSettings.Attribute.define((String)"searchguard.authtokens.cleanup_interval").withDefault(TimeValue.timeValueHours((long)1L)).asTimeValue();
    public static final String USER_TYPE = "sg_auth_token";
    public static final String USER_TYPE_FULL_CURRENT_PERMISSIONS = "sg_auth_token_full_current_permissions";
    private final String indexName;
    private final PrivilegedConfigClient privilegedConfigClient;
    private final ConfigHistoryService configHistoryService;
    private final ComponentState componentState;
    private final AuthorizationService authorizationService;
    private final PrivilegesEvaluator privilegesEvaluator;
    private final Actions actions;
    private final Cache<String, AuthToken> idToAuthTokenMap = CacheBuilder.newBuilder().expireAfterWrite(60L, TimeUnit.MINUTES).build();
    private JoseJwtProducer jwtProducer;
    private String jwtAudience;
    private JsonWebKey encryptionKey;
    private JsonWebKey signingKey;
    private JwsSignatureVerifier jwsSignatureVerifier;
    private JweDecryptionProvider jweDecryptionProvider;
    private AuthTokenServiceConfig config;
    private boolean sendTokenUpdates = true;
    private boolean initialized = false;
    private IndexCleanupAgent indexCleanupAgent;
    private long maxTokensPerUser = 100L;

    public AuthTokenService(PrivilegedConfigClient privilegedConfigClient, AuthorizationService authorizationService, PrivilegesEvaluator privilegesEvaluator, ConfigHistoryService configHistoryService, StaticSettings settings, ThreadPool threadPool, ClusterService clusterService, ProtectedConfigIndexService protectedConfigIndexService, Actions actions, AuthTokenServiceConfig config, ComponentState componentState) {
        this.indexName = (String)settings.get(INDEX_NAME);
        this.privilegedConfigClient = privilegedConfigClient;
        this.configHistoryService = configHistoryService;
        this.componentState = componentState;
        this.authorizationService = authorizationService;
        this.privilegesEvaluator = privilegesEvaluator;
        this.actions = actions;
        this.setConfig(config);
        ProtectedConfigIndexService.ConfigIndex configIndex = new ProtectedConfigIndexService.ConfigIndex(this.indexName).mapping(AuthToken.INDEX_MAPPING).onIndexReady(this::init);
        if (configHistoryService != null) {
            configIndex.dependsOnIndices(new String[]{configHistoryService.getIndexName()});
        }
        componentState.addPart(protectedConfigIndexService.createIndex(configIndex));
        this.indexCleanupAgent = new IndexCleanupAgent(this.indexName, "expires_at", (TimeValue)settings.get(CLEANUP_INTERVAL), (Client)privilegedConfigClient, clusterService, threadPool);
    }

    public AuthTokenService(PrivilegedConfigClient privilegedConfigClient, AuthorizationService authorizationService, PrivilegesEvaluator privilegesEvaluator, ConfigHistoryService configHistoryService, StaticSettings settings, ThreadPool threadPool, ClusterService clusterService, ProtectedConfigIndexService protectedConfigIndexService, Actions actions, AuthTokenServiceConfig config) {
        this(privilegedConfigClient, authorizationService, privilegesEvaluator, configHistoryService, settings, threadPool, clusterService, protectedConfigIndexService, actions, config, new ComponentState(1000, null, "auth_token_service"));
    }

    public AuthToken getById(String id) throws NoSuchAuthTokenException {
        AuthToken result = (AuthToken)this.idToAuthTokenMap.getIfPresent((Object)id);
        if (result != null) {
            return result;
        }
        return this.getByIdFromIndex(id);
    }

    public void getById(String id, Consumer<AuthToken> onResult, Consumer<NoSuchAuthTokenException> onNoSuchAuthToken, Consumer<Exception> onFailure) {
        AuthToken result = (AuthToken)this.idToAuthTokenMap.getIfPresent((Object)id);
        if (result != null) {
            onResult.accept(result);
        } else {
            this.getByIdFromIndex(id, onResult, onNoSuchAuthToken, onFailure);
        }
    }

    public AuthToken getByIdFromIndex(String id) throws NoSuchAuthTokenException {
        CompletableFuture completableFuture = new CompletableFuture();
        this.getByIdFromIndex(id, completableFuture::complete, completableFuture::completeExceptionally, completableFuture::completeExceptionally);
        try {
            return (AuthToken)completableFuture.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof NoSuchAuthTokenException) {
                throw (NoSuchAuthTokenException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    public void getByIdFromIndex(final String id, final Consumer<AuthToken> onResult, final Consumer<NoSuchAuthTokenException> onNoSuchAuthToken, final Consumer<Exception> onFailure) {
        this.privilegedConfigClient.get(new GetRequest(this.indexName, id), (ActionListener)new ActionListener<GetResponse>(){

            public void onResponse(GetResponse getResponse) {
                if (getResponse.isExists()) {
                    try {
                        AuthToken authToken = AuthToken.parse(id, DocNode.parse((Format)Format.JSON).from(getResponse.getSourceAsString()));
                        AuthTokenService.this.idToAuthTokenMap.put((Object)id, (Object)authToken);
                        onResult.accept(authToken);
                    }
                    catch (ConfigValidationException e) {
                        onFailure.accept(new RuntimeException("Token " + id + " is not stored in a valid format", e));
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                        onFailure.accept(e);
                    }
                } else {
                    onNoSuchAuthToken.accept(new NoSuchAuthTokenException(id));
                }
            }

            public void onFailure(Exception e) {
                if (e instanceof IndexNotFoundException) {
                    onNoSuchAuthToken.accept(new NoSuchAuthTokenException(id));
                } else {
                    onFailure.accept(e);
                }
            }
        });
    }

    public AuthToken getByClaims(Map<String, Object> claims) throws NoSuchAuthTokenException, InvalidTokenException {
        CompletableFuture completableFuture = new CompletableFuture();
        this.getByClaims(claims, completableFuture::complete, completableFuture::completeExceptionally, completableFuture::completeExceptionally);
        try {
            return (AuthToken)completableFuture.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof NoSuchAuthTokenException) {
                throw (NoSuchAuthTokenException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    public void getByClaims(Map<String, Object> claims, Consumer<AuthToken> onResult, Consumer<NoSuchAuthTokenException> onNoSuchAuthToken, Consumer<Exception> onFailure) throws InvalidTokenException {
        String id = Objects.toString(claims.get("jti"), null);
        Set<String> audience = this.getClaimAsSet(claims, "aud");
        if (!audience.contains(this.jwtAudience)) {
            throw new InvalidTokenException("Invalid JWT audience claim. Supplied: " + audience + "; Expected: " + this.jwtAudience);
        }
        if (id == null) {
            throw new InvalidTokenException("Supplied auth token does not have an id claim");
        }
        this.getById(id, onResult, onNoSuchAuthToken, onFailure);
    }

    public void getByIdWithConfigSnapshot(String id, Consumer<AuthToken> onResult, Consumer<NoSuchAuthTokenException> onNoSuchAuthToken, Consumer<Exception> onFailure) {
        this.getById(id, authToken -> {
            if (authToken.getBase().getConfigVersions() == null || authToken.getBase().peekConfigSnapshot() != null) {
                onResult.accept((AuthToken)authToken);
            } else {
                this.configHistoryService.getConfigSnapshot(authToken.getBase().getConfigVersions(), configSnapshot -> {
                    authToken.getBase().setConfigSnapshot((ConfigSnapshot)configSnapshot);
                    onResult.accept((AuthToken)authToken);
                }, onFailure);
            }
        }, onNoSuchAuthToken, onFailure);
    }

    public AuthToken getByIdWithConfigSnapshot(String id) throws NoSuchAuthTokenException {
        CompletableFuture completableFuture = new CompletableFuture();
        this.getByIdWithConfigSnapshot(id, completableFuture::complete, completableFuture::completeExceptionally, completableFuture::completeExceptionally);
        try {
            return (AuthToken)completableFuture.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof NoSuchAuthTokenException) {
                throw (NoSuchAuthTokenException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    public AuthToken create(User user, CreateAuthTokenRequest request) throws TokenCreationException {
        long existingTokenCount;
        Map<String, Object> baseAttributes;
        HashSet<String> baseSearchGuardRoles;
        HashSet<String> baseBackendRoles;
        ConfigSnapshot configSnapshot;
        if (this.config == null || !this.config.isEnabled()) {
            throw new TokenCreationException("Auth token handling is not enabled", RestStatus.INTERNAL_SERVER_ERROR);
        }
        if (log.isDebugEnabled()) {
            log.debug("create(user: " + user + ", request: " + (Object)((Object)request) + ")");
        }
        if (USER_TYPE.equals(user.getType())) {
            log.debug("User is based on an auth token. Resulting auth token will be based on the original one");
            String authTokenId = (String)user.getSpecialAuthzConfig();
            try {
                AuthToken existingAuthToken = this.getByIdWithConfigSnapshot(authTokenId);
                configSnapshot = existingAuthToken.getBase().getConfigSnapshot();
                baseBackendRoles = new HashSet<String>(existingAuthToken.getBase().getBackendRoles());
                baseSearchGuardRoles = new HashSet<String>(existingAuthToken.getBase().getSearchGuardRoles());
                baseAttributes = existingAuthToken.getBase().getAttributes();
            }
            catch (NoSuchAuthTokenException e) {
                this.componentState.addLastException("create", (Throwable)e);
                throw new TokenCreationException("Error while creating auth token: Could not find base token " + authTokenId, RestStatus.INTERNAL_SERVER_ERROR, e);
            }
        } else {
            configSnapshot = request.isFreezePrivileges() && this.config.getFreezePrivileges() == AuthTokenServiceConfig.FreezePrivileges.USER_CHOOSES || this.config.getFreezePrivileges() == AuthTokenServiceConfig.FreezePrivileges.ALWAYS ? this.configHistoryService.getCurrentConfigSnapshot(CType.ROLES, CType.ROLESMAPPING, CType.ACTIONGROUPS, CType.TENANTS) : null;
            baseBackendRoles = user.getRoles();
            baseSearchGuardRoles = user.getSearchGuardRoles();
            baseAttributes = user.getStructuredAttributes();
        }
        String id = this.getRandomId();
        AuthTokenPrivilegeBase base = new AuthTokenPrivilegeBase(this.restrictRoles(request, baseBackendRoles), this.restrictRoles(request, baseSearchGuardRoles), baseAttributes, configSnapshot != null ? configSnapshot.getConfigVersions() : null);
        if (log.isDebugEnabled()) {
            log.debug("base for auth token " + (Object)((Object)request) + ": " + base);
        }
        base.setConfigSnapshot(configSnapshot);
        if (base.getBackendRoles().size() == 0 && base.getSearchGuardRoles().size() == 0) {
            throw new TokenCreationException("Cannot create token. The resulting token would have no privileges as the specified roles do not intersect with the user's roles. Specified: " + request.getRequestedPrivileges().getRoles() + " User: " + baseBackendRoles + " + " + baseSearchGuardRoles, RestStatus.BAD_REQUEST);
        }
        if (this.maxTokensPerUser == 0L) {
            throw new TokenCreationException("Cannot create token. max_tokens_per_user is set to 0", RestStatus.FORBIDDEN);
        }
        if (this.maxTokensPerUser > 0L && (existingTokenCount = this.countAuthTokensOfUser(user)) + 1L > this.maxTokensPerUser) {
            throw new TokenCreationException("Cannot create token. Token limit per user exceeded. Max number of allowed tokens is " + this.maxTokensPerUser, RestStatus.FORBIDDEN);
        }
        OffsetDateTime now = OffsetDateTime.now().withNano(0);
        OffsetDateTime expiresAt = this.getExpiryTime(now, request);
        RequestedPrivileges requestedPrivilegesWithDefaultExclusions = request.getRequestedPrivileges().excludeClusterPermissions(this.config.getExcludeClusterPermissions()).excludeIndexPermissions(this.config.getExcludeIndexPermissions());
        AuthToken authToken = new AuthToken(id, user.getName(), request.getTokenName(), requestedPrivilegesWithDefaultExclusions, base, now.toInstant(), expiresAt != null ? expiresAt.toInstant() : null, null);
        try {
            this.updateAuthToken(authToken, PushAuthTokenUpdateRequest.UpdateType.NEW);
        }
        catch (Exception e) {
            this.componentState.addLastException("create", (Throwable)e);
            throw new TokenCreationException("Error while creating token", RestStatus.INTERNAL_SERVER_ERROR, e);
        }
        return authToken;
    }

    public CreateAuthTokenResponse createJwt(User user, CreateAuthTokenRequest request) throws TokenCreationException {
        String encodedJwt;
        if (this.jwtProducer == null) {
            throw new TokenCreationException("AuthTokenProvider is not configured", RestStatus.INTERNAL_SERVER_ERROR);
        }
        AuthToken authToken = this.create(user, request);
        JwtClaims jwtClaims = new JwtClaims();
        JwtToken jwt = new JwtToken(jwtClaims);
        jwtClaims.setNotBefore(Long.valueOf(authToken.getCreationTime().getEpochSecond()));
        if (authToken.getExpiryTime() != null) {
            jwtClaims.setExpiryTime(Long.valueOf(authToken.getExpiryTime().getEpochSecond()));
        }
        jwtClaims.setSubject(user.getName());
        jwtClaims.setTokenId(authToken.getId());
        jwtClaims.setAudience(this.config.getJwtAud());
        jwtClaims.setProperty("requested", ObjectTreeXContent.toObjectTree((ToXContent)authToken.getRequestedPrivileges()));
        jwtClaims.setProperty("base", ObjectTreeXContent.toObjectTree((ToXContent)authToken.getBase(), (ToXContent.Params)AuthTokenPrivilegeBase.COMPACT));
        try {
            encodedJwt = this.jwtProducer.processJwt(jwt);
        }
        catch (Exception e) {
            this.componentState.addLastException("createJwt", new ComponentState.ExceptionRecord((Throwable)e, "Error while creating JWT. Possibly the key configuration is not valid."));
            log.error("Error while creating JWT. Possibly the key configuration is not valid.", (Throwable)e);
            throw new TokenCreationException("Error while creating JWT. Possibly the key configuration is not valid.", RestStatus.INTERNAL_SERVER_ERROR, e);
        }
        return new CreateAuthTokenResponse(authToken, encodedJwt);
    }

    public CreateAuthTokenResponse createLightweightJwt(User user, CreateAuthTokenRequest request) throws TokenCreationException {
        String encodedJwt;
        if (this.jwtProducer == null) {
            throw new TokenCreationException("AuthTokenProvider is not configured", RestStatus.INTERNAL_SERVER_ERROR);
        }
        AuthToken authToken = this.create(user, request);
        JwtClaims jwtClaims = new JwtClaims();
        JwtToken jwt = new JwtToken(jwtClaims);
        jwtClaims.setNotBefore(Long.valueOf(authToken.getCreationTime().getEpochSecond()));
        if (authToken.getExpiryTime() != null) {
            jwtClaims.setExpiryTime(Long.valueOf(authToken.getExpiryTime().getEpochSecond()));
        }
        jwtClaims.setSubject(user.getName());
        jwtClaims.setTokenId(authToken.getId());
        jwtClaims.setAudience(this.config.getJwtAud());
        try {
            encodedJwt = this.jwtProducer.processJwt(jwt);
        }
        catch (Exception e) {
            log.error("Error while creating JWT. Possibly the key configuration is not valid.", (Throwable)e);
            throw new TokenCreationException("Error while creating JWT. Possibly the key configuration is not valid.", RestStatus.INTERNAL_SERVER_ERROR, e);
        }
        return new CreateAuthTokenResponse(authToken, encodedJwt);
    }

    public JwtToken getVerifiedJwtToken(String encodedJwt) throws JwtException {
        boolean signatureValid;
        JwsJwtCompactConsumer jwtConsumer;
        JwtToken jwt;
        if (this.jweDecryptionProvider != null) {
            JweDecryptionOutput decOutput = this.jweDecryptionProvider.decrypt(encodedJwt);
            encodedJwt = decOutput.getContentText();
        }
        if (!this.validateAudience((jwt = (jwtConsumer = new JwsJwtCompactConsumer(encodedJwt)).getJwtToken()).getClaims())) {
            if (log.isTraceEnabled()) {
                log.trace("Not checking this token because it has a different audience: " + jwt.getClaims().getAudience());
            }
            return null;
        }
        if (this.jwsSignatureVerifier != null && !(signatureValid = jwtConsumer.verifySignatureWith(this.jwsSignatureVerifier))) {
            throw new JwtException("Invalid JWT signature for token " + jwt.getClaims().asMap());
        }
        this.validateClaims(jwt);
        return jwt;
    }

    public String revoke(User user, String id) throws NoSuchAuthTokenException, TokenUpdateException {
        AuthToken authToken;
        if (log.isTraceEnabled()) {
            log.trace("revoke(" + user + ", " + id + ")");
        }
        if ((authToken = this.getById(id)).getRevokedAt() != null) {
            log.info("Auth token " + authToken + " was already revoked");
            return "Auth token was already revoked";
        }
        String updateStatus = this.updateAuthToken(authToken.getRevokedInstance(), PushAuthTokenUpdateRequest.UpdateType.REVOKED);
        if (updateStatus != null) {
            return updateStatus;
        }
        return "Auth token has been revoked";
    }

    public void setConfig(AuthTokenServiceConfig config) {
        if (config == null) {
            return;
        }
        this.config = config;
        this.jwtAudience = config.getJwtAud();
        this.maxTokensPerUser = config.getMaxTokensPerUser();
        this.setKeys(config.getJwtSigningKey(), config.getJwtEncryptionKey());
    }

    private void init(ProtectedConfigIndexService.FailureListener failureListener) {
        this.initComplete();
        failureListener.onSuccess();
        this.componentState.updateStateFromParts();
    }

    private void validateClaims(JwtToken jwt) throws JwtException {
        JwtClaims claims = jwt.getClaims();
        if (claims == null) {
            throw new JwtException("The JWT does not have any claims");
        }
        JwtUtils.validateJwtExpiry((JwtClaims)claims, (int)0, (boolean)false);
        JwtUtils.validateJwtNotBefore((JwtClaims)claims, (int)0, (boolean)false);
    }

    private boolean validateAudience(JwtClaims claims) throws JwtException {
        if (this.jwtAudience != null) {
            for (String audience : claims.getAudiences()) {
                if (!this.jwtAudience.equals(audience)) continue;
                return true;
            }
        }
        return false;
    }

    private synchronized void initComplete() {
        this.initialized = true;
        this.notifyAll();
    }

    public synchronized void waitForInitComplete(long timeoutMillis) {
        if (this.initialized) {
            return;
        }
        try {
            this.wait(timeoutMillis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.initialized) {
            throw new RuntimeException(this + " did not initialize after " + timeoutMillis);
        }
    }

    public String pushAuthTokenUpdate(PushAuthTokenUpdateRequest request) {
        AuthToken updatedAuthToken;
        AuthToken existingAuthToken;
        if (log.isDebugEnabled()) {
            log.debug("got auth token update: " + (Object)((Object)request));
        }
        if ((existingAuthToken = (AuthToken)this.idToAuthTokenMap.getIfPresent((Object)(updatedAuthToken = request.getUpdatedToken()).getId())) == null) {
            return "Auth token is not cached";
        }
        this.idToAuthTokenMap.put((Object)updatedAuthToken.getId(), (Object)updatedAuthToken);
        return "Auth token updated";
    }

    private String updateAuthToken(AuthToken authToken, PushAuthTokenUpdateRequest.UpdateType updateType) throws TokenUpdateException {
        AuthToken oldToken = null;
        try {
            oldToken = this.getById(authToken.getId());
        }
        catch (NoSuchAuthTokenException e) {
            oldToken = null;
        }
        if (updateType == PushAuthTokenUpdateRequest.UpdateType.NEW && oldToken != null) {
            throw new TokenUpdateException("Token ID already exists: " + authToken.getId());
        }
        try (XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();){
            authToken.toXContent(xContentBuilder, ToXContent.EMPTY_PARAMS);
            IndexResponse indexResponse = (IndexResponse)this.privilegedConfigClient.index((IndexRequest)new IndexRequest(this.indexName).id(authToken.getId()).source(xContentBuilder).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).actionGet();
            if (log.isDebugEnabled()) {
                log.debug("Token stored: " + indexResponse);
            }
        }
        catch (Exception e) {
            if (oldToken != null) {
                this.idToAuthTokenMap.put((Object)oldToken.getId(), (Object)oldToken);
            } else {
                this.idToAuthTokenMap.invalidate((Object)authToken.getId());
            }
            log.warn("Error while storing token " + authToken, (Throwable)e);
            throw new TokenUpdateException(e);
        }
        if (!this.sendTokenUpdates) {
            return "Update disabled";
        }
        try {
            PushAuthTokenUpdateResponse pushAuthTokenUpdateResponse = (PushAuthTokenUpdateResponse)((Object)this.privilegedConfigClient.execute((ActionType)PushAuthTokenUpdateAction.INSTANCE, (ActionRequest)new PushAuthTokenUpdateRequest(authToken, updateType, 0L)).actionGet());
            if (log.isDebugEnabled()) {
                log.debug("Token update pushed: " + (Object)((Object)pushAuthTokenUpdateResponse));
            }
            if (pushAuthTokenUpdateResponse.hasFailures()) {
                return "Update partially failed: " + pushAuthTokenUpdateResponse.failures();
            }
        }
        catch (Exception e) {
            log.warn("Token update push failed: " + authToken, (Throwable)e);
            return "Update partially failed: " + e;
        }
        return null;
    }

    private long countAuthTokensOfUser(User user) {
        SearchRequest searchRequest = new SearchRequest(new String[]{this.getIndexName()}).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.termQuery((String)"user_name", (String)user.getName())).size(0));
        SearchResponse searchResponse = (SearchResponse)this.privilegedConfigClient.search(searchRequest).actionGet();
        return searchResponse.getHits().getTotalHits().value;
    }

    private OffsetDateTime getExpiryTime(OffsetDateTime now, CreateAuthTokenRequest request) {
        OffsetDateTime expiresAfter = null;
        OffsetDateTime expiresAfterMax = null;
        if (request.getExpiresAfter() != null) {
            expiresAfter = now.plus(request.getExpiresAfter());
        }
        if (this.config.getMaxValidity() != null) {
            expiresAfterMax = now.plus(this.config.getMaxValidity());
        }
        if (expiresAfter == null) {
            expiresAfter = expiresAfterMax;
        } else if (expiresAfter != null && expiresAfterMax != null && expiresAfterMax.isBefore(expiresAfter)) {
            expiresAfter = expiresAfterMax;
        }
        return expiresAfter;
    }

    private String getRandomId() {
        UUID uuid = UUID.randomUUID();
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[16]);
        byteBuffer.putLong(uuid.getMostSignificantBits());
        byteBuffer.putLong(uuid.getLeastSignificantBits());
        String result = BaseEncoding.base64Url().encode(byteBuffer.array()).replace("=", "");
        return result;
    }

    void initJwtProducer() {
        try {
            this.jwtProducer = new JoseJwtProducer();
            if (this.signingKey != null) {
                this.jwtProducer.setSignatureProvider(JwsUtils.getSignatureProvider((JsonWebKey)this.signingKey));
                this.jwsSignatureVerifier = JwsUtils.getSignatureVerifier((JsonWebKey)this.signingKey);
            } else {
                this.jwsSignatureVerifier = null;
            }
            if (this.encryptionKey != null) {
                this.jwtProducer.setEncryptionProvider(JweUtils.createJweEncryptionProvider((JsonWebKey)this.encryptionKey, (ContentAlgorithm)ContentAlgorithm.A256CBC_HS512));
                this.jwtProducer.setJweRequired(true);
                this.jweDecryptionProvider = JweUtils.createJweDecryptionProvider((JsonWebKey)this.encryptionKey, (ContentAlgorithm)ContentAlgorithm.A256CBC_HS512);
            } else {
                this.jweDecryptionProvider = null;
            }
        }
        catch (Exception e) {
            this.componentState.setFailed((Throwable)e);
            this.componentState.setSubState("jwt_producer_not_initialized");
            this.jwtProducer = null;
            log.error("Error while initializing JWT producer in AuthTokenProvider", (Throwable)e);
        }
    }

    public JsonWebKey getSigningKey() {
        return this.signingKey;
    }

    public void setSigningKey(JsonWebKey signingKey) {
        if (Objects.equals(this.signingKey, signingKey)) {
            return;
        }
        log.info("Updating signing key for " + this);
        this.signingKey = signingKey;
        this.initJwtProducer();
    }

    public JsonWebKey getEncryptionKey() {
        return this.encryptionKey;
    }

    public void setEncryptionKey(JsonWebKey encryptionKey) {
        if (Objects.equals(this.encryptionKey, encryptionKey)) {
            return;
        }
        log.info("Updating encryption key for " + this);
        this.encryptionKey = encryptionKey;
        this.initJwtProducer();
    }

    public void setKeys(JsonWebKey signingKey, JsonWebKey encryptionKey) {
        if (Objects.equals(this.signingKey, signingKey) && Objects.equals(this.encryptionKey, encryptionKey)) {
            return;
        }
        log.info("Updating keys for " + this);
        this.signingKey = signingKey;
        this.encryptionKey = encryptionKey;
        this.initJwtProducer();
    }

    private Set<String> getClaimAsSet(Map<String, Object> claims, String claimName) {
        Object claim = claims.get(claimName);
        if (claim == null) {
            return Collections.emptySet();
        }
        if (claim instanceof Collection) {
            return ((Collection)claim).stream().map(e -> String.valueOf(e)).collect(Collectors.toSet());
        }
        return Collections.singleton(String.valueOf(claim));
    }

    private Set<String> restrictRoles(CreateAuthTokenRequest request, Set<String> roles) {
        if (request.getRequestedPrivileges().getRoles() != null) {
            return Sets.intersection(new HashSet<String>((Collection<String>)request.getRequestedPrivileges().getRoles()), roles);
        }
        return roles;
    }

    public void provide(User user, ThreadContext threadContext, Consumer<SpecialPrivilegesEvaluationContext> onResult, Consumer<Exception> onFailure) {
        if (this.config == null || !this.config.isEnabled()) {
            onResult.accept(null);
            return;
        }
        if (user == null || !USER_TYPE.equals(user.getType())) {
            onResult.accept(null);
            return;
        }
        String authTokenId = (String)user.getSpecialAuthzConfig();
        if (log.isDebugEnabled()) {
            log.debug("AuthTokenService.provide(" + user.getName() + ") on " + authTokenId);
        }
        Supplier restorableCtx = threadContext.newRestorableContext(true);
        try (ThreadContext.StoredContext ctx = threadContext.stashContext();){
            this.getByIdWithConfigSnapshot(authTokenId, arg_0 -> this.lambda$provide$3((Supplier)restorableCtx, onResult, user, threadContext, authTokenId, onFailure, arg_0), arg_0 -> AuthTokenService.lambda$provide$4((Supplier)restorableCtx, onFailure, authTokenId, arg_0), onFailure);
        }
    }

    public void shutdown() {
        this.indexCleanupAgent.shutdown();
    }

    private ConfigModel getCurrentConfigModel() {
        return new ConfigModel((ActionAuthorization)this.privilegesEvaluator.getActionAuthorization(), this.authorizationService.getRoleMapping(), this.privilegesEvaluator.getActionGroups());
    }

    public String getIndexName() {
        return this.indexName;
    }

    boolean isSendTokenUpdates() {
        return this.sendTokenUpdates;
    }

    void setSendTokenUpdates(boolean sendTokenUpdates) {
        this.sendTokenUpdates = sendTokenUpdates;
    }

    public AuthTokenServiceConfig getConfig() {
        return this.config;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public ComponentState getComponentState() {
        this.componentState.updateStateFromParts();
        return this.componentState;
    }

    public boolean isEnabled() {
        return this.config != null && this.config.isEnabled();
    }

    private static /* synthetic */ void lambda$provide$4(Supplier restorableCtx, Consumer onFailure, String authTokenId, NoSuchAuthTokenException noSuchAuthTokenException) {
        try (ThreadContext.StoredContext restoredCtx = (ThreadContext.StoredContext)restorableCtx.get();){
            onFailure.accept(new ElasticsearchSecurityException("Cannot authenticate user due to invalid auth token " + authTokenId, (Exception)noSuchAuthTokenException, new Object[0]));
        }
    }

    private /* synthetic */ void lambda$provide$3(Supplier restorableCtx, Consumer onResult, User user, ThreadContext threadContext, String authTokenId, Consumer onFailure, AuthToken authToken) {
        try {
            ConfigModel configModelSnapshot;
            if (log.isTraceEnabled()) {
                log.trace("Got token: " + authToken);
            }
            if (authToken.isRevoked()) {
                log.info("Using revoked auth token: " + authToken);
                try (ThreadContext.StoredContext restoredCtx = (ThreadContext.StoredContext)restorableCtx.get();){
                    onResult.accept(null);
                    return;
                }
            }
            if (authToken.getBase().getConfigSnapshot() == null) {
                configModelSnapshot = this.getCurrentConfigModel();
            } else {
                if (authToken.getBase().getConfigSnapshot().hasMissingConfigVersions()) {
                    throw new RuntimeException("Stored config snapshot is not complete: " + authToken);
                }
                configModelSnapshot = this.configHistoryService.getConfigModelForSnapshot(authToken.getBase().getConfigSnapshot());
            }
            User userWithRoles = user.copy().backendRoles(authToken.getBase().getBackendRoles()).searchGuardRoles(authToken.getBase().getSearchGuardRoles()).build();
            TransportAddress callerTransportAddress = (TransportAddress)threadContext.getTransient("_sg_remote_address");
            ImmutableSet mappedBaseRoles = configModelSnapshot.getRoleMapping().evaluate(userWithRoles, callerTransportAddress, this.privilegesEvaluator.getRolesMappingResolution());
            if (log.isDebugEnabled()) {
                log.debug("AuthTokenService.provide returns SpecialPrivilegesEvaluationContext for " + user + "\nuserWithRoles: " + userWithRoles + "\nmappedBaseRoles: " + mappedBaseRoles);
            }
            RestrictedActionAuthorization restrictedSgRoles = new RestrictedActionAuthorization(configModelSnapshot.getActionAuthorization(), authToken.getRequestedPrivileges(), configModelSnapshot.getActionGroups(), this.actions, null, (Set<String>)this.privilegesEvaluator.getActionAuthorization().getTenants());
            try (ThreadContext.StoredContext restoredCtx = (ThreadContext.StoredContext)restorableCtx.get();){
                onResult.accept(new SpecialPrivilegesEvaluationContextImpl(userWithRoles, (Set<String>)mappedBaseRoles, restrictedSgRoles, configModelSnapshot.getRolesConfig(), authToken.getRequestedPrivileges()));
            }
        }
        catch (Exception e) {
            log.error("Error in provide(" + user + "); authTokenId: " + authTokenId, (Throwable)e);
            try (ThreadContext.StoredContext restoredCtx = (ThreadContext.StoredContext)restorableCtx.get();){
                onFailure.accept(e);
            }
        }
    }

    static class SpecialPrivilegesEvaluationContextImpl
    implements SpecialPrivilegesEvaluationContext {
        private final User user;
        private final ImmutableSet<String> mappedRoles;
        private final ActionAuthorization actionAuthorization;
        private final SgDynamicConfiguration<Role> rolesConfig;
        private final RequestedPrivileges requestedPrivileges;

        SpecialPrivilegesEvaluationContextImpl(User user, Set<String> mappedRoles, ActionAuthorization actionAuthorization, SgDynamicConfiguration<Role> rolesConfig, RequestedPrivileges requestedPrivileges) {
            this.user = user;
            this.mappedRoles = ImmutableSet.of(mappedRoles);
            this.actionAuthorization = actionAuthorization;
            this.requestedPrivileges = requestedPrivileges;
            this.rolesConfig = rolesConfig;
        }

        public User getUser() {
            return this.user;
        }

        public ImmutableSet<String> getMappedRoles() {
            return this.mappedRoles;
        }

        public ActionAuthorization getActionAuthorization() {
            return this.actionAuthorization;
        }

        public boolean isSgConfigRestApiAllowed() {
            return (this.requestedPrivileges.getClusterPermissions().contains((Object)"*") || this.requestedPrivileges.getClusterPermissions().contains((Object)"cluster:admin:searchguard:configrestapi")) && !this.requestedPrivileges.getExcludedClusterPermissions().contains((Object)"cluster:admin:searchguard:configrestapi");
        }

        public SgDynamicConfiguration<Role> getRolesConfig() {
            return this.rolesConfig;
        }
    }
}

